(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 14.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     33479,        903]
NotebookOptionsPosition[     30413,        844]
NotebookOutlinePosition[     30809,        860]
CellTagsIndexPosition[     30766,        857]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"T", " ", "=", " ", 
  RowBox[{"(", GridBox[{
     {"1", "0"},
     {
      RowBox[{"r", "*", 
       RowBox[{"(", 
        RowBox[{"r", "-", "d"}], ")"}]}], "1"}
    }], ")"}], " "}]], "Input",
 CellChangeTimes->{{3.929279434058901*^9, 3.929279435078808*^9}, {
   3.929279527652284*^9, 3.929279564559193*^9}, {3.9292796019911175`*^9, 
   3.929279702862051*^9}, {3.92927973535273*^9, 3.929279785131836*^9}, {
   3.9292798174602947`*^9, 3.9292798285989876`*^9}, {3.9292801044916687`*^9, 
   3.929280123975029*^9}, {3.929280242180813*^9, 3.9292802703911057`*^9}, {
   3.92928039793182*^9, 3.929280448946863*^9}, {3.929280752432993*^9, 
   3.9292807826994*^9}, 3.9292808323281384`*^9, {3.9292811293067627`*^9, 
   3.929281162745531*^9}, {3.929281219475668*^9, 3.929281236861719*^9}, {
   3.929281390517044*^9, 3.9292814004007397`*^9}, {3.9292814491204853`*^9, 
   3.929281460598768*^9}, {3.929281639356303*^9, 3.929281648044918*^9}, {
   3.929281744455214*^9, 3.929281770160712*^9}, {3.92928242645556*^9, 
   3.929282437276991*^9}, {3.929282476068262*^9, 3.929282476422701*^9}, {
   3.929282630512031*^9, 3.929282655202116*^9}, 3.929282797670363*^9, {
   3.929283344252491*^9, 3.9292833637560444`*^9}, 3.929286050843881*^9, {
   3.9292868764340057`*^9, 3.929286880439266*^9}, {3.92928719979565*^9, 
   3.9292872210580997`*^9}, {3.9292874954021626`*^9, 3.929287556754721*^9}, {
   3.949579245330664*^9, 3.949579369230517*^9}, {3.949675943296896*^9, 
   3.949675996278423*^9}, 3.949676299990078*^9, {3.949676626700947*^9, 
   3.949676627021988*^9}, {3.9496768061115837`*^9, 3.949676806765781*^9}, 
   3.949758772610136*^9, {3.949764274492234*^9, 3.949764296307774*^9}, {
   3.9497649354667263`*^9, 3.9497649358930473`*^9}, 3.949765089651407*^9, {
   3.949766108776011*^9, 3.949766109355507*^9}, {3.950344457042332*^9, 
   3.95034446023263*^9}, {3.950344570382099*^9, 3.9503445820413494`*^9}, {
   3.9561441432332745`*^9, 3.956144144480858*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"90d5f73b-287f-8f42-b3c0-d88e205093aa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}]}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.929294118850422*^9, {3.9495793534458313`*^9, 3.949579371439005*^9}, 
   3.9496760004828243`*^9, 3.949676302781927*^9, 3.949676629783661*^9, 
   3.9496768098814297`*^9, 3.949758774973812*^9, 3.949764299497701*^9, 
   3.949764937935034*^9, 3.949765091929603*^9, 3.9497661115508957`*^9, 
   3.950344462986695*^9, 3.950359366207033*^9, 3.9503602388000584`*^9, 
   3.9561441511975594`*^9, 3.958292865726656*^9, 3.973871274673971*^9, 
   3.9738714121251335`*^9, 3.9738717679974823`*^9, 3.9738718783726654`*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"12a910c3-d06a-934d-bfd8-99f2ed425839"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", "=", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {
       FractionBox[
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}]}], 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]], 
       RowBox[{"1", "-", 
        FractionBox[
         SuperscriptBox["h", "\[Alpha]"], 
         RowBox[{"r", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], 
  RowBox[{"(*", 
   RowBox[{"A", " ", "=", " ", 
    RowBox[{"D", " ", "in", " ", "the", " ", "paper"}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.929279803720674*^9, 3.929279955576357*^9}, {
   3.929280135583111*^9, 3.929280144840465*^9}, {3.9292802813710556`*^9, 
   3.9292803009570236`*^9}, {3.9292803350265083`*^9, 3.929280338478174*^9}, {
   3.9292804705325203`*^9, 3.92928054178204*^9}, {3.929280804328483*^9, 
   3.92928082820907*^9}, {3.929281084785969*^9, 3.929281101275228*^9}, {
   3.9292811717187576`*^9, 3.929281197282463*^9}, {3.9292812456995587`*^9, 
   3.929281279847098*^9}, {3.929281370247715*^9, 3.929281384459751*^9}, {
   3.9292814245924873`*^9, 3.929281437702051*^9}, {3.929281653671589*^9, 
   3.9292816695968227`*^9}, {3.9292818099031315`*^9, 3.929281839696518*^9}, {
   3.9292826759526787`*^9, 3.929282706378315*^9}, {3.929282833078703*^9, 
   3.9292828541675014`*^9}, {3.929283312893509*^9, 3.929283333373584*^9}, {
   3.929286410024631*^9, 3.9292864247681856`*^9}, {3.929286468836881*^9, 
   3.929286479397098*^9}, {3.929287021096472*^9, 3.929287021681078*^9}, {
   3.92928723085157*^9, 3.9292872590192165`*^9}, {3.929287566336149*^9, 
   3.9292875910390453`*^9}, {3.929292300675623*^9, 3.929292301150078*^9}, {
   3.949579383860235*^9, 3.9495794658230705`*^9}, {3.949676022689556*^9, 
   3.949676129554508*^9}, {3.949764308886664*^9, 3.949764332896335*^9}, 
   3.950344488912361*^9, 3.9561441962366905`*^9, {3.9738712946538486`*^9, 
   3.9738713078381977`*^9}, {3.973871421899477*^9, 3.9738714326534214`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"c77322c7-9d5f-ba45-bc76-f1fda06828ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}]}], 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]], ",", 
     RowBox[{"1", "-", 
      FractionBox[
       SuperscriptBox["h", "\[Alpha]"], 
       RowBox[{"r", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.9292941323411508`*^9, {3.949579440535551*^9, 3.949579467364916*^9}, 
   3.949676132756342*^9, 3.9496763063989544`*^9, 3.949676632997736*^9, 
   3.949676812415343*^9, 3.9497587775141335`*^9, 3.9497643341777687`*^9, 
   3.949764953605549*^9, 3.950344491471588*^9, 3.950359369761217*^9, 
   3.950360241527464*^9, 3.956144197757162*^9, 3.958292865812195*^9, {
   3.9738712964407043`*^9, 3.973871314513424*^9}, 3.9738714142772846`*^9, 
   3.9738717690907784`*^9, 3.973871878497879*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"61123c40-0626-3945-b444-0fed9070f71d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LM", "=", " ", 
    RowBox[{
     RowBox[{"Inverse", "[", "T", "]"}], ".", "A", ".", "T"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"for", " ", "the", " ", "linear", " ", 
    RowBox[{"part", ":", " ", 
     RowBox[{
      SuperscriptBox["T", 
       RowBox[{"-", "1"}]], "AT"}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LM", " ", "=", " ", 
   RowBox[{"MatrixForm", "[", "LM", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "LM", "]"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJwdz00og3EcB/CnOWjlxNR2GbIUSmpWsoO2FlOTtTkIaRbZNPyFzGGEx8tB
sy0X2WGE9tTYmnlprc3LZUnRUF4iyU0WRd5Knu//8OtTv76H77fA3GfoFDAM
I+UPyty38fGaF5XrIpGEdxVG8wSvtmeTmusYsMD9lwUrtMlLCfwSslRb98gw
tDTdUNOK3XHIvoYn4dkq44H2DDfVa/UF4DMxbUBND9mGXYwqCv1v+gSMickB
POmN50zyrnzWSSBbEmyBR8pfaui7gsDWj9p+6D9OWljs8eVZ4eCoaA1mEsk6
TMlKj6G/Xn8K7c7IORRyoUtYnnVfNoU97e9URpSugq6xYiWVKKqhJkeuhvmL
f0NQVyh1QK0gysKALzINIx4jBxsHnwKw/GlGNY1erkotNG39GGaQC+41wo5l
3SH0qtuo748N3Cz+3DDVlj135Vzi+8tS1/ChuUgyzysmdqo3GQtDZiO+A/8B
xCnwww==
  "],ExpressionUUID->"68e2cc65-21da-844a-b56f-4339ff3bb2d8"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0"},
     {"0", 
      RowBox[{"1", "-", 
       FractionBox[
        SuperscriptBox["h", "\[Alpha]"], 
        RowBox[{"r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.929294147457032*^9, 3.929294158194083*^9}, {
   3.9495794766180344`*^9, 3.949579483537405*^9}, {3.94967614852977*^9, 
   3.9496761538200264`*^9}, {3.9496763093254185`*^9, 3.949676314714109*^9}, 
   3.949676455149147*^9, {3.9496766357367077`*^9, 3.9496766436160183`*^9}, {
   3.949676817710573*^9, 3.9496768226896973`*^9}, {3.94975878027297*^9, 
   3.949758785813625*^9}, {3.949764336409277*^9, 3.949764338403559*^9}, {
   3.949764956181027*^9, 3.949764960328392*^9}, 3.950344493286518*^9, 
   3.950359356271509*^9, 3.950359388424761*^9, 3.950360244344101*^9, 
   3.9561442005685863`*^9, 3.9582928658245525`*^9, {3.973871312051708*^9, 
   3.973871316441084*^9}, {3.973871417454132*^9, 3.9738714368366528`*^9}, 
   3.973871794501852*^9, 3.973871878526989*^9},
 CellLabel->
  "Out[5]//MatrixForm=",ExpressionUUID->"f883bdda-a6a9-b048-946e-\
732b8f276d48"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"doing", " ", "the", " ", "translation", " ", 
    RowBox[{"(", 
     RowBox[{"u", ",", "v"}], ")"}]}], " ", "=", " ", 
   RowBox[{"T", " ", 
    RowBox[{"(", " ", 
     RowBox[{"x", ",", "y"}], ")"}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.950344514225092*^9, 3.9503445538775806`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"e5e6fd61-82dc-6549-8623-c59e22c2c89e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"u", " ", "=", " ", "x"}], "\[IndentingNewLine]", 
 RowBox[{"v", " ", "=", 
  RowBox[{
   RowBox[{"r", "*", 
    RowBox[{"(", 
     RowBox[{"r", "-", "d"}], ")"}], "*", "x"}], "+", 
   "y"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.929292478846873*^9, 3.9292925217317257`*^9}, {
   3.92929258511763*^9, 3.929292862831389*^9}, {3.9495840914850655`*^9, 
   3.949584195370713*^9}, {3.949758547111725*^9, 3.949758605516512*^9}, 
   3.949758685477897*^9, 3.9497588010464497`*^9, {3.949764897287579*^9, 
   3.94976489869771*^9}, {3.950344588869417*^9, 3.9503446360562325`*^9}, {
   3.9503450010085773`*^9, 3.950345011431977*^9}, {3.9561442088234024`*^9, 
   3.956144252794945*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"2e233eb9-f1e2-7b45-b394-bd089dc54f1a"],

Cell[BoxData["x"], "Output",
 CellChangeTimes->{
  3.92929417707337*^9, 3.949584200357252*^9, {3.9497585925097237`*^9, 
   3.9497586065820713`*^9}, 3.949758687964725*^9, {3.9497587892621098`*^9, 
   3.9497588032653027`*^9}, 3.94976490206106*^9, 3.949764963530836*^9, 
   3.9503446024956264`*^9, 3.9503446371433334`*^9, {3.950345002371063*^9, 
   3.950345012844742*^9}, 3.95035939328195*^9, 3.9503602545000668`*^9, {
   3.9561442210086136`*^9, 3.956144254400461*^9}, 3.9582928658314342`*^9, 
   3.973871320386223*^9, 3.973871442958252*^9, 3.973871799612524*^9, 
   3.973871878549078*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"f49a760b-a639-3f48-b1ae-155c3d3b2e6d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", "x"}], "+", "y"}]], "Output",
 CellChangeTimes->{
  3.92929417707337*^9, 3.949584200357252*^9, {3.9497585925097237`*^9, 
   3.9497586065820713`*^9}, 3.949758687964725*^9, {3.9497587892621098`*^9, 
   3.9497588032653027`*^9}, 3.94976490206106*^9, 3.949764963530836*^9, 
   3.9503446024956264`*^9, 3.9503446371433334`*^9, {3.950345002371063*^9, 
   3.950345012844742*^9}, 3.95035939328195*^9, 3.9503602545000668`*^9, {
   3.9561442210086136`*^9, 3.956144254400461*^9}, 3.9582928658314342`*^9, 
   3.973871320386223*^9, 3.973871442958252*^9, 3.973871799612524*^9, 
   3.973871878554079*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"105bc3b8-7bae-ea43-b6a1-bd4a2bc4eb89"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"B", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"h", "^", "\[Alpha]"}], "/", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "*", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", "u", ")"}], "*", 
          RowBox[{"(", "v", ")"}]}], ")"}]}]},
      {
       RowBox[{"u", "*", "v"}]}
     }], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.9292929973161945`*^9, 3.929293257302248*^9}, 
   3.929294191576653*^9, 3.929294295092339*^9, {3.9495842332336464`*^9, 
   3.949584242074463*^9}, {3.950344640145225*^9, 3.950344644796549*^9}, {
   3.9561442591738567`*^9, 3.9561442610949078`*^9}, {3.973871452282627*^9, 
   3.9738714581915627`*^9}, 3.973871810115471*^9},
 CellLabel->"In[9]:=",ExpressionUUID->"543807f3-ec68-9147-8e78-e1d03c363bc6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", "x"}], "+", "y"}], 
        ")"}]}], 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}], "}"}], ",", 
   RowBox[{"{", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", "x"}], "+", "y"}], 
       ")"}]}], 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.950344645258745*^9, 3.950345005426443*^9, 
  3.950359396888708*^9, 3.9503602580800285`*^9, 3.9561442626954575`*^9, 
  3.9582928658314342`*^9, 3.973871324886133*^9, 3.973871462840145*^9, 
  3.973871802103489*^9, 3.973871878570278*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"7da5f99f-e882-0043-ad8c-574076c22bd7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"QM", "=", " ", 
    RowBox[{
     RowBox[{"Inverse", "[", "T", "]"}], ".", "B"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"for", " ", "the", " ", "nonlinear", " ", 
    RowBox[{"part", ":", " ", 
     RowBox[{
      SuperscriptBox["T", 
       RowBox[{"-", "1"}]], "B"}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QM", "=", " ", 
   RowBox[{"MatrixForm", "[", "QM", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{"Simplify", "[", "QM", "]"}]}]}], "Input",
 CellChangeTimes->{{3.929293285908048*^9, 3.9292933159416485`*^9}, {
   3.92929339571788*^9, 3.929293411885607*^9}, {3.929293900200737*^9, 
   3.929293901668659*^9}, {3.9292946802290955`*^9, 3.929294681305168*^9}, 
   3.949584247147604*^9, {3.950346306751137*^9, 3.9503463074719257`*^9}, 
   3.9503463431366043`*^9, 3.9738718122237015`*^9, {3.9738730885342884`*^9, 
   3.973873117712229*^9}},ExpressionUUID->"234bf2a6-00cb-a74a-8709-\
38fa5a7cf81f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", "x"}], "+", "y"}], 
          ")"}]}], 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}]},
     {
      FractionBox[
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"d", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "d"}], " ", "r", " ", "x"}], "+", 
          RowBox[{
           SuperscriptBox["r", "2"], " ", "x"}], "+", "y"}], ")"}]}], 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9503593997025375`*^9, 3.950360260817644*^9, 3.956144265816309*^9, 
   3.95829286585104*^9, 3.9738713277424107`*^9, 3.973871465135517*^9, {
   3.9738718651656036`*^9, 3.973871878596302*^9}},
 CellLabel->
  "Out[12]//MatrixForm=",ExpressionUUID->"024e75f9-31b1-324f-b247-\
45d909022498"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", " ", "=", " ", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", "x"}], "+", "y"}], 
        ")"}]}], 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "^", "2"}], ",", "xy"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9582928854536896`*^9, 3.9582929312730293`*^9}, {
  3.9738714855475693`*^9, 3.9738714863064957`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"2e204b4a-fe07-8043-a58b-f9bc80d8344a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", "y"}], 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}]], "Output",
 CellChangeTimes->{{3.9582929015029507`*^9, 3.9582929328171577`*^9}, 
   3.9738714953419304`*^9, 3.973871824047518*^9, 3.973871878618559*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"94e8b0f0-5f3d-fd4e-86d2-e9cbc09fe996"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", " ", "=", " ", 
  RowBox[{"Collect", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"d", " ", "r"}], "+", 
        SuperscriptBox["r", "2"]}], ")"}], " ", "x", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "d"}], " ", "r", " ", "x"}], "+", 
        RowBox[{
         SuperscriptBox["r", "2"], " ", "x"}], "+", "y"}], ")"}]}], 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "^", "2"}], ",", "xy"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.9582929590057564`*^9, {3.973871497959463*^9, 3.973871498509102*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"3b5da30a-95bd-b547-a031-6496c6dac027"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "d"}], " ", "r"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"d", " ", "r"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[Alpha]"}], "]"}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"d", " ", "r"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}], " ", "x", " ", "y"}], 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}]], "Output",
 CellChangeTimes->{3.9582929606045227`*^9, 3.973871499361414*^9, 
  3.9738718266562023`*^9, 3.9738718786277695`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"938b4ca9-75df-9f49-91a5-d77a9c2f8149"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "apply", " ", "the", " ", "center", " ", "manifold", " ", "theory"}], 
  "*)"}]], "Input",
 CellChangeTimes->{
  3.950344661339966*^9, {3.950344977783457*^9, 3.9503449888298607`*^9}, {
   3.9738715043890038`*^9, 3.973871529121744*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"3148bae5-ca5c-d34b-9070-bf5a2910533b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"c1", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"c2", " ", 
     RowBox[{"x", "^", "3"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"QM1", "=", 
   RowBox[{"QM", "/.", " ", 
    RowBox[{"y", "->", 
     RowBox[{"h", "[", "x", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9503446607392025`*^9, 3.950344660740196*^9}, {
   3.9503460024655247`*^9, 3.950346003394108*^9}, 3.950359271418993*^9, {
   3.950359331249042*^9, 3.9503593340202227`*^9}, {3.9503594210745125`*^9, 
   3.950359439012262*^9}, {3.956144285102434*^9, 3.95614428668338*^9}, 
   3.9738715623368664`*^9},
 CellLabel->"In[16]:=",ExpressionUUID->"70a4a52f-bffe-2446-b33b-edbbc07bfa02"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  RowBox[{"w", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0"},
      {"0", 
       RowBox[{"1", "-", 
        FractionBox[
         SuperscriptBox["h", "\[Alpha]"], 
         RowBox[{"r", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}]}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Input",
 CellChangeTimes->{{3.950359441568302*^9, 3.950359441948131*^9}, {
  3.956144296952116*^9, 3.9561443389510136`*^9}, {3.9561444587293797`*^9, 
  3.956144462966669*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"0bf2d3f3-32ae-2042-b218-e04d0eae62de"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"1", "-", 
      FractionBox[
       SuperscriptBox["h", "\[Alpha]"], 
       RowBox[{"r", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9561444642523746`*^9, 3.9582928658790913`*^9, 
  3.973871573971773*^9, 3.9738718345427456`*^9, 3.9738718786580505`*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"af574be9-fb3e-ac4d-b58e-4287d241a8e4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq12", "=", 
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"w", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", "x"}], "+", 
      RowBox[{
       RowBox[{"w", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], "*", 
       RowBox[{"h", "[", "x", "]"}]}], "+", 
      RowBox[{"QM1", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], "==", 
    RowBox[{
     RowBox[{
      RowBox[{"w", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}], "*", "x"}], "+", 
     RowBox[{
      RowBox[{"w", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
      RowBox[{"h", "[", "x", "]"}]}], "+", 
     RowBox[{"QM1", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"LHS", " ", "=", " ", 
   RowBox[{"h", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"w", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", "x"}], "+", 
     RowBox[{
      RowBox[{"w", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}], "*", 
      RowBox[{"h", "[", "x", "]"}]}], "+", 
     RowBox[{"QM1", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RHS", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1"}], "]"}], "]"}], "*", "x"}], "+", 
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
     RowBox[{"h", "[", "x", "]"}]}], "+", 
    RowBox[{"QM1", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LHSExpanded", "=", 
   RowBox[{"Expand", "[", "LHS", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"RHSExpanded", "=", 
   RowBox[{"Expand", "[", "RHS", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    RowBox[{"Coefficient", "[", 
     RowBox[{"LHSExpanded", ",", "x", ",", "2"}], "]"}], "==", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"RHSExpanded", ",", "x", ",", "2"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"eq2", "=", 
    RowBox[{
     RowBox[{"Coefficient", "[", 
      RowBox[{"LHSExpanded", ",", "x", ",", "3"}], "]"}], "==", 
     RowBox[{"Coefficient", "[", 
      RowBox[{"RHSExpanded", ",", "x", ",", "3"}], "]"}]}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"solution", "=", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"eq1", ",", "eq2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c1", ",", "c2"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "solution"}], "Input",
 CellChangeTimes->{{3.950359308922306*^9, 3.950359323298187*^9}, {
  3.956144392120659*^9, 3.9561443938549843`*^9}, {3.956144477365696*^9, 
  3.9561444789932003`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"071f5e32-2f81-7f43-9407-2f4611a031ad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"c1", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "d"}], " ", 
       SuperscriptBox["r", "2"]}], "+", 
      SuperscriptBox["r", "3"], "+", 
      RowBox[{
       SuperscriptBox["d", "2"], " ", 
       SuperscriptBox["r", "3"]}], "-", 
      RowBox[{"2", " ", "d", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      SuperscriptBox["r", "5"]}]}], ",", 
    RowBox[{"c2", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "-", 
        RowBox[{"3", " ", "d", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["r", "3"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "d"}], " ", 
         SuperscriptBox["r", "2"]}], "+", 
        SuperscriptBox["r", "3"], "+", 
        RowBox[{
         SuperscriptBox["d", "2"], " ", 
         SuperscriptBox["r", "3"]}], "-", 
        RowBox[{"2", " ", "d", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        SuperscriptBox["r", "5"]}], ")"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.958292865892189*^9, 3.9738715777745285`*^9, {3.973871840402315*^9, 
   3.9738718786821213`*^9}},
 CellLabel->"Out[27]=",ExpressionUUID->"40eb0ae0-28d3-a246-b41c-ea2411f98133"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"beta", " ", "=", " ", 
   RowBox[{
    RowBox[{"r", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["r", "2"], "-", "rd"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "dr"}], " ", "+", " ", 
       SuperscriptBox["r", "2"], "+", "1"}], ")"}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "d"}], " ", 
       SuperscriptBox["r", "2"]}], "+", 
      SuperscriptBox["r", "3"], "+", 
      RowBox[{
       SuperscriptBox["d", "2"], " ", 
       SuperscriptBox["r", "3"]}], "-", 
      RowBox[{"2", " ", "d", " ", 
       SuperscriptBox["r", "4"]}], "+", 
      SuperscriptBox["r", "5"]}], "=", " ", "c1"}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.973872045514271*^9, 
  3.973872157284157*^9}},ExpressionUUID->"55529a56-08d5-ed45-b8f0-\
73a1b90f5e42"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"gamma", " ", "=", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["r", "2"], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["r", "2"], "-", "rd"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", "rd", " ", "+", " ", 
       SuperscriptBox["r", "2"]}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", 
        SuperscriptBox["r", "2"]}], "-", 
       RowBox[{"3", "rd"}], "+", "1"}], ")"}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "-", 
        RowBox[{"3", " ", "d", " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["r", "3"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "d"}], " ", 
         SuperscriptBox["r", "2"]}], "+", 
        SuperscriptBox["r", "3"], "+", 
        RowBox[{
         SuperscriptBox["d", "2"], " ", 
         SuperscriptBox["r", "3"]}], "-", 
        RowBox[{"2", " ", "d", " ", 
         SuperscriptBox["r", "4"]}], "+", 
        SuperscriptBox["r", "5"]}], ")"}]}], "=", " ", "c2"}]}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.973872164751604*^9, 
  3.973872248496401*^9}},ExpressionUUID->"f2463078-8cde-194a-9652-\
a55a6c44fabb"]
},
WindowSize->{949, 521},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.1 for Microsoft Windows (64-bit) (July 16, 2024)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"ef81c3b0-87ab-134e-bdb4-190ceb7c568d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 2040, 33, 41, "Input",ExpressionUUID->"90d5f73b-287f-8f42-b3c0-d88e205093aa"],
Cell[2623, 57, 886, 20, 32, "Output",ExpressionUUID->"12a910c3-d06a-934d-bfd8-99f2ed425839"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3546, 82, 2583, 53, 53, "Input",ExpressionUUID->"c77322c7-9d5f-ba45-bc76-f1fda06828ea"],
Cell[6132, 137, 1187, 30, 49, "Output",ExpressionUUID->"61123c40-0626-3945-b444-0fed9070f71d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7356, 172, 1126, 26, 66, "Input",ExpressionUUID->"68e2cc65-21da-844a-b56f-4339ff3bb2d8"],
Cell[8485, 200, 1553, 35, 70, "Output",ExpressionUUID->"f883bdda-a6a9-b048-946e-732b8f276d48"]
}, Open  ]],
Cell[10053, 238, 431, 10, 28, "Input",ExpressionUUID->"e5e6fd61-82dc-6549-8623-c59e22c2c89e"],
Cell[CellGroupData[{
Cell[10509, 252, 795, 15, 66, "Input",ExpressionUUID->"2e233eb9-f1e2-7b45-b394-bd089dc54f1a"],
Cell[11307, 269, 664, 10, 32, "Output",ExpressionUUID->"f49a760b-a639-3f48-b1ae-155c3d3b2e6d"],
Cell[11974, 281, 789, 15, 32, "Output",ExpressionUUID->"105bc3b8-7bae-ea43-b6a1-bd4a2bc4eb89"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12800, 301, 860, 22, 41, "Input",ExpressionUUID->"543807f3-ec68-9147-8e78-e1d03c363bc6"],
Cell[13663, 325, 1192, 34, 49, "Output",ExpressionUUID->"7da5f99f-e882-0043-ad8c-574076c22bd7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14892, 364, 986, 23, 66, "Input",ExpressionUUID->"234bf2a6-00cb-a74a-8709-38fa5a7cf81f"],
Cell[15881, 389, 1709, 50, 86, "Output",ExpressionUUID->"024e75f9-31b1-324f-b247-45d909022498"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17627, 444, 783, 22, 46, "Input",ExpressionUUID->"2e204b4a-fe07-8043-a58b-f9bc80d8344a"],
Cell[18413, 468, 713, 19, 51, "Output",ExpressionUUID->"94e8b0f0-5f3d-fd4e-86d2-e9cbc09fe996"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19163, 492, 854, 24, 50, "Input",ExpressionUUID->"3b5da30a-95bd-b547-a031-6496c6dac027"],
Cell[20020, 518, 959, 28, 53, "Output",ExpressionUUID->"938b4ca9-75df-9f49-91a5-d77a9c2f8149"]
}, Open  ]],
Cell[20994, 549, 357, 8, 28, "Input",ExpressionUUID->"3148bae5-ca5c-d34b-9070-bf5a2910533b"],
Cell[21354, 559, 793, 20, 66, "Input",ExpressionUUID->"70a4a52f-bffe-2446-b33b-edbbc07bfa02"],
Cell[CellGroupData[{
Cell[22172, 583, 965, 26, 53, "Input",ExpressionUUID->"0bf2d3f3-32ae-2042-b218-e04d0eae62de"],
Cell[23140, 611, 584, 16, 49, "Output",ExpressionUUID->"af574be9-fb3e-ac4d-b58e-4287d241a8e4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23761, 632, 3171, 98, 218, "Input",ExpressionUUID->"071f5e32-2f81-7f43-9407-2f4611a031ad"],
Cell[26935, 732, 1315, 39, 34, "Output",ExpressionUUID->"40eb0ae0-28d3-a246-b41c-ea2411f98133"]
}, Open  ]],
Cell[28265, 774, 859, 26, 30, "Input",ExpressionUUID->"55529a56-08d5-ed45-b8f0-73a1b90f5e42"],
Cell[29127, 802, 1282, 40, 30, "Input",ExpressionUUID->"f2463078-8cde-194a-9652-a55a6c44fabb"]
}
]
*)

